# APRS模拟信标

## 软件作者

[BG7IAE](https://bg7iae.com)

---

## 📝 使用说明

1. 获取生成的 APRS-IS 登录密码，必须由真实呼号在 [Passcode Generator](https://apps.magicbug.co.uk/passcode/) 生成。注意！！！不要使用虚假呼号申请，冒用他人呼号是违法行为。
2. 将 `passcode` 填入 `config.json` 中的 `passcode` 字段。
3. 根据需要修改其他配置项，具体参考 [字段说明与建议](#-字段说明与建议)。
4. 在 Windows 环境下运行 `aprs_beacon.exe`，程序会自动启动并上传数据。
5. 注意事项：`config.json` 必须与 `aprs_beacon.exe` 放在同一目录下，否则程序无法正常运行。

---

## 🧠 字段说明与建议

| 字段名                | 类型        | 说明 |
|-----------------------|-------------|------|
| `callsign`            | string      | 用户呼号，必须是有效的业余无线电呼号 |
| `passcode`            | string      | APRS-IS 登录密码，由呼号生成【[获取方式](https://apps.magicbug.co.uk/passcode/)】 |
| `upload_to_aprs_is`   | boolean     | 是否上传到 APRS-IS 网络（aprs.fi 可见） |
| `interval_enabled`    | boolean     | 是否启用定时发送 |
| `interval_seconds`    | integer     | 定时发送间隔（单位：秒） |
| `address`             | string      | 初始地址，用于获取坐标 |
| `latitude_override`   | float/null  | 手动指定纬度（优先于地址） |
| `longitude_override`  | float/null  | 手动指定经度（优先于地址） |
| `simulate_track`      | boolean     | 是否启用轨迹模拟（从地址移动到目标地址） |
| `track_target_address`| string      | 轨迹目标地址 |
| `track_speed_kmh`     | integer     | 模拟移动速度（单位：km/h）。当前实现暂未使用，后续版本将结合 `interval_seconds` 动态计算步长 |
| `track_steps`         | integer     | 模拟轨迹分段数（控制平滑度） |
| `symbol`              | string      | APRS 图标符号代码（例如 `>` 表示车辆）。注意与 `symbol_table` 区分 |
| `symbol_table`        | string      | APRS 符号表选择（`/` 为 primary，`\` 为 secondary） |
| `comment`             | string      | APRS 包中的注释字段 |
| `server`              | string      | APRS-IS 上传服务器（推荐使用本地 Tier2） |
| `log_enabled`         | boolean     | 是否记录发送日志 |
| `log_path`            | string      | 日志文件保存路径 |
| `debug_mode`          | boolean     | 是否启用调试输出 |
| `tcp_port`            | integer     | APRS-IS 服务器端口（常用 14580） |
| `retry_on_fail`       | boolean     | 发送失败后是否自动重试 |
| `max_retry`           | integer     | 最大重试次数 |

---
